/* -*- Mode:C; Tab-width:4 -*- */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C) 1987,1988,1989,1990 Texas Instruments Incorporated.    */
/*  All rights reserved.                                                 */
/*                                                                       */

/* 11/01/89 clm - made some minor changes to compile under MPW 3.0  */

#include <rpc.h>
#include <stdio.h>
#include <files.h>
#include <quickdraw.h>
#include <devices.h>
#include <fonts.h>
#include <events.h>
#include <windows.h>
#include <osutils.h>
#include <menus.h>
#include <textedit.h>
#include <dialogs.h>
#include <toolutils.h>
#include <desk.h>
#include <stdio.h>
#include <errors.h>
#include <serial.h>
#include <strings.h>
#include <errno.h>
#include <wlw.h>
#include <osevents.h>   /* clm - needed for flushevents */
 
#define RPC_SLEEP_TIME 0

#define DEBUG 1

#define wait_key()                                                                        \
{                                                                                         \
  SysBeep(5);                                                                             \
  printf("Press Any Key To Continue ---\n");                                              \
  while (event_handler(-1, 0) != keyDown);                                        \
}

static Boolean doneFlag = false;
Boolean mydebugflag = false;

#ifdef DEBUG
#define	debugM 3		/* was 4, removed file */
#define	debugID	131
#define	MenuCount 3		/* was 4, removed file */
#else
#define MenuCount 2		/* was 3, removed file */
#endif

#define appleID 128 			
#define	fileID	129
#define	editID	130	
#define appleM	1				
/* #define	fileM	2 */
#define	editM	2		/* was 3, removed file */
#define	aboutMeCommand 1 		

MenuHandle myMenus[MenuCount+1];

static void
SetUpMenus()
/* set up menus and menu bar */
{
  int x;
  
  myMenus[appleM] = GetMenu(appleID);   /* read Apple menu from resource file */
  AddResMenu(myMenus[appleM], 'DRVR');  /* add desk accessory names to Apple menu */
/*  removed file -- Tung */
/*  myMenus[fileM] = GetMenu(fileID); */    /* read file menu from resource file */
  myMenus[editM] = GetMenu(editID);     /* read Edit menu from resource file */

#ifdef DEBUG
  myMenus[debugM] = NewMenu(debugID,"\pDebug");
  AppendMenu(myMenus[debugM],"\pOn");
  AppendMenu(myMenus[debugM],"\pOff");
  AppendMenu(myMenus[debugM],"\pNow");
  CheckItem(myMenus[debugM],2,true);
#endif

  for(x=1; x<=MenuCount; x++)         
	InsertMenu(myMenus[x], 0); 
  DrawMenuBar();					  
}

#define aboutMeDLOG 128
#define okButton 1
#define authorItem 2
#define languageItem 3

static void
ShowAboutMeDialog()
  /* Display a dialog box in response to the 'About Lispm' menu item */
{
  short itemHit, *itemType = NULL;
  Handle *itemHdl = NULL;
  Rect *itemRect = NULL;
  DialogPtr theDialog;
  
  theDialog = GetNewDialog(aboutMeDLOG, NULL, (WindowPtr)- 1);
  GetDItem(theDialog, authorItem, itemType, itemHdl, itemRect);
  SetIText(*itemHdl, "\pAdvanced Systems Division.");   
  GetDItem(theDialog, languageItem, itemType, itemHdl, itemRect);
  SetIText(*itemHdl, "\pC/Pascal/Assembly.");    
  
  do
	ModalDialog(NULL, &itemHit);
  while (itemHit != okButton);
  
  CloseDialog(theDialog);
}
 
static void
DoCommand(mResult)
	 long mResult;
  /* Execute command specified by mResult, the result of MenuSelect */
{
  short theItem; 	/* menu item number from mResult low-order word */
  short theMenu; 	/* menu number from mResult high-order word */
  char *name = NULL; 		/* desk accessory name */
  short temp;
  /* long templ;	sbw 12/11/89 */
  
  theItem = LoWord(mResult);  /* call Toolbox Utility routines to */
  theMenu = HiWord(mResult);  /* set menu item number and menu number */
  
  switch(theMenu)
	{
	case appleID:
	  if(theItem == aboutMeCommand)
		ShowAboutMeDialog();
	  else
		{					  
		  GetItem(myMenus[appleM], theItem, name); 
		  temp = OpenDeskAcc(name);                
		  SetPort(qd.thePort);		            
		} 		                             
	  break;
/*  removed file -- Tung */
/*	case fileID:
	  doneFlag = true;	                          
	  break; */
#ifdef DEBUG
	case debugID:
	  switch(theItem)
		{
		case 1:	
		  mydebugflag = true;
		  CheckItem(myMenus[debugM],1,true);
		  CheckItem(myMenus[debugM],2,false);
		  break;
		case 2:
		  mydebugflag = false;
		  CheckItem(myMenus[debugM],1,false);
		  CheckItem(myMenus[debugM],2,true);
		  break;
		case 3:
		  DebugStr("hello");
		  break;
		}
	  break;
#endif
	}			                   
  HiliteMenu(0);				   
}


int
event_handler(event_mask, wait_time)
{
  short whichPart;
  WindowPtr whichWindow;
  EventRecord event;
  
  if(WaitNextEvent(event_mask, &event, wait_time, NULL))
	{
	  switch(event.what)
		{
		case mouseDown:
		  whichPart = findwindow(&event.where, &whichWindow);  /* clm - use findwindow instead of FindWindow */
          /* gDebugWindowPtr is bound to the cold load stream window */
		  if(whichWindow == gDebugWindowPtr)
			WWMouseDown(whichPart,event.where,event.modifiers);
		  else
			switch(whichPart)
			  {
			  case inSysWindow:	
				  SystemClick(&event, whichWindow);
				  break;
			  case inMenuBar:
				  DoCommand(MenuSelect(event.where));
				  break;
			  default:			  
				  break;
			  }
		case activateEvt:
		  if(((WindowPtr)event.message) == gDebugWindowPtr)
			WWActivateEvent(event.modifiers);
		  break;
		case updateEvt:
		  if(((WindowPtr) event.message) == gDebugWindowPtr) WWUpdateEvent();
		  break;
		default:
		  break;
		}
	}
  
  mac_application_run();
  return event.what;
}

#define NO_APPLICATION_NAME -1
#define TRAP_CHANNEL_OUT_OF_RANGE -2
#define NO_TRAP_TABLE -3
#define MICRONET_INITIALIZE_FAILED -4

static char lisp_error_string[255];

#define program_number    0x20118651
#define version_number    1
#define procedure_number  1

main()
{
  int current_time, stat, error;
  Boolean quit_flag = false;

  InitGraf(&qd.thePort); 
  InitFonts();
  FlushEvents(everyEvent, 0);
  InitWindows();
  InitMenus();
  TEInit();
  InitDialogs(NULL);
  InitCursor();
  
  /* Rect r;	12/11/89 sbw */

  /* WWInit is used to set up the cold load stream window for output. */
  WWInit() ;

  SetUpMenus();
  switch(error = mac_application_init())
	{
	  case 0:
		/* Success. */
		break;
		
	  case NO_APPLICATION_NAME:
		paramtext("There is no lisp application name.","","Exitting to Finder","");
		NoteAlert (260,0);
		exit(-1);
		break;
		
	  case NO_TRAP_TABLE:
		paramtext("Error while launching application: ", "Trap resource initialization failed", "Exitting to Finder", "");
		NoteAlert (260,0);
		exit(-1);
		break;

	  case TRAP_CHANNEL_OUT_OF_RANGE:
		paramtext("Trap channel out of range.","","Exitting to Finder","");
		NoteAlert (260,0);
		exit(-1);
		break;

	  default:
		paramtext("Error while launching application: ", lisp_error_string, "Exitting to Finder", "");
		NoteAlert (260,0);
		exit(-1);
		break;

	}

  do
	{
	  event_handler(everyEvent, RPC_SLEEP_TIME);
	  if((stat = callrpc("mx",
						 program_number,
						 version_number,
						 procedure_number,
						 xdr_void,
						 0,
						 xdr_int,
						 &current_time)) != 0)
		{ 
			printf("error:  callrpc stat = %d\n", stat);
			wait_key();
		}
	  else
		{   
			printf("RPC succeeded, Current time = %x\n", current_time);
			wait_key();
			exit();
		}
	} while(!quit_flag);
  tb_shutdown();
  rpc_shutdown();
  exit(noErr);
}
